
/**********************************************************************
  common check funtion.
**********************************************************************/

/* check input number */
function checkNum (title, value, min, max)
{
  var message = '';

  if ((value == '') ||
      ((min < 0) && (!value.match(/^\+?[0-9]+$|^-?[0-9]+$/g))) ||
      ((min >= 0) && (value.match(/[^0-9]/g))) ||
      (value < min) ||
      (value > max))
  {
    message = I18N.get(title) + I18N.get("'s value is in range ") + min + "-" + max + I18N.get(".");
  }

  return message;
}

/* check input float number */
function checkFloatNum (title, value, min, max)
{
  var message = '';

  if ((value == '') || 
      (!value.match(/^-?\d+\.?\d*$/g)) || 
      (parseFloat(value) < parseFloat(min)) || 
      (parseFloat(value) > parseFloat(max)))
  {
    message = I18N.get(title) + I18N.get("'s value is in range") + min + "-" + max + I18N.get(".");
  }

  return message;
}

/* check input hexadecimal value */
function checkHex (title, value, min, max)
{
  var message = '';
  var val = parseInt('0x'+value);
  var valMin = parseInt('0x'+min);
  var valMax = parseInt('0x'+max);

  if ((value == '') || (value.match(/[^0-9|^a-f]/gi)) || (val < valMin) || (val > valMax))
  {
    message = I18N.get(title) + I18N.get("'s value is in range ") + min + "-" + max + I18N.get(".");
  }

  return message;
}

/* check subnet mask */
function checkSubnetMask (ipArr)
{
  var  checkMask;
  var  isZero = false;

  for (var i = 0; i < 4; i++)
  {
    checkMask = 0x80;

    for (var j = 0; j < 8; j++, checkMask = checkMask >> 1)
    {
      if (isZero == false)
      {
        /* check if is 0 */
        if ((ipArr[i] & checkMask) != checkMask)
        {
            isZero = true;
        }
      }
      else
      {
         /* have 0 , check if is 1 */
        if ((ipArr[i] & checkMask) == checkMask)
        {
            return false;
        }
      }
    }
  }

  return true;
}

/***********************************
check input ip range.
note  :
     title -- the obj title
     ipArr -- ip address array
     zeroIpValid (true/false)      -- zero ip (0.0.0.0) is vaild or not
     zeroNetworkValid (true/false) -- zero network ip (0.xxx.xxx.xxx) is vaild or not
     loopBackValid (true/false)    -- loop back ip (127.xxx.xxx.xxx) is vaild or not
     multicastValid (true/false)   -- multicast ip (224.0.0.0 ~ 239.255.255.255) is vaild or not
     testingValid (true/false)     -- testing ip (240.0.0.0 ~ 255.255.255.254) is vaild or not
     broadcastValid (true/false)   -- broadcast ip (255.255.255.255) is vaild or not
***********************************/
function checkIpRange (title, ipArr, zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid)
{
  var message = '';

  if (zeroIpValid == false)
  {
    /* check if is zero ip (0.0.0.0) */
    if ((parseInt(ipArr[0]) == 0) && (parseInt(ipArr[1]) == 0)
         && (parseInt(ipArr[2]) == 0) && (parseInt(ipArr[3]) == 0))
    {
      message = I18N.get(title) + I18N.get(" can't be zero IP (0.0.0.0).");
      return message;
    }
  }

  if (zeroNetworkValid == false)
  {
    /* check if is zero network ip (0.xxx.xxx.xxx) */
    if (parseInt(ipArr[0]) == 0)
    {
      /* check if zero ip (0.0.0.0) is valid */
      if (!((zeroIpValid == true) && (parseInt(ipArr[1]) == 0)
           && (parseInt(ipArr[2]) == 0) && (parseInt(ipArr[3]) == 0)))
      {
        message = I18N.get(title) + I18N.get(" can't be zero network IP (0.xxx.xxx.xxx).");
        return message;
      }
    }
  }

  if (loopBackValid == false)
  {
    /* check if is loop back ip (127.xxx.xxx.xxx)*/
    if (parseInt(ipArr[0]) == 127)
    {
      message = I18N.get(title) + I18N.get(" can't be loop back IP (127.xxx.xxx.xxx).");
      return message;
    }
  }

  if (multicastValid == false)
  {
    /* check if is multicast ip (224.0.0.0 ~ 239.255.255.255)*/
    if (parseInt(ipArr[0]) >= 224 && parseInt(ipArr[0]) <= 239)
    {
      message = I18N.get(title) + I18N.get(" can't be multicast IP (224.0.0.0 ~ 239.255.255.255).");
      return message;
    }
  }

  if (testingValid == false)
  {
    /* check if is testing ip (240.0.0.0 ~ 255.255.255.254) */
    if (parseInt(ipArr[0]) >= 240 && parseInt(ipArr[0]) <=255)
    {
      /* check is not broadcast ip (255.255.255.255) */
      if (!((parseInt(ipArr[0]) == 255) && (parseInt(ipArr[1]) == 255) &&
          (parseInt(ipArr[2]) == 255) && (parseInt(ipArr[3]) == 255)))
      {
        message = I18N.get(title) + I18N.get(" can't be testing IP (240.0.0.0 ~ 255.255.255.254).");
        return message;
      }
    }
  }

  if (broadcastValid == false)
  {
    /* check if is broadcast ip (255.255.255.255) */
    if ((parseInt(ipArr[0]) == 255) && (parseInt(ipArr[1]) == 255) &&
        (parseInt(ipArr[2]) == 255) && (parseInt(ipArr[3]) == 255))
    {
      message = I18N.get(title) + I18N.get(" can't be broadcast IP (255.255.255.255).");
      return message;
    }
  }

  return message;
}

/***********************************
check input ip class.
note  :
     title -- the obj title
     ipArr -- ip address array
     classAValid (true/false)   -- class A (1~127) is vaild or not
     classBValid (true/false)   -- class B (128~191) is vaild or not
     classCValid (true/false)   -- class C (192~223) is vaild or not
     classDValid (true/false)   -- class D (224~239) is vaild or not
     classEValid (true/false)   -- class E (240~255) is vaild or not
***********************************/
function checkIpClass (title, ipArr, classAValid, classBValid, classCValid, classDValid, classEValid)
{
  var message = '';

  if (classAValid == false)
  {
    /* check if in class A (1~127) */
    if ((parseInt(ipArr[0]) >= 1) && (parseInt(ipArr[0]) <= 127))
    {
      message = I18N.get(title) + I18N.get(" can't be 1.0.0.0 ~ 127.255.255.255");
      return message;
    }
  }

  if (classBValid == false)
  {
    /* check if in class B (128~191) */
    if ((parseInt(ipArr[0]) >= 128) && (parseInt(ipArr[0]) <= 191))
    {
      message = I18N.get(title) + I18N.get(" can't be 128.0.0.0 ~ 191.255.255.255");
      return message;
    }
  }

  if (classCValid == false)
  {
    /* check if in class C (192~223) */
    if ((parseInt(ipArr[0]) >= 192) && (parseInt(ipArr[0]) <= 223))
    {
      message = I18N.get(title) + I18N.get(" can't be 192.0.0.0 ~ 223.255.255.255");
      return message;
    }
  }

  if (classDValid == false)
  {
    /* check if in class D (224~239) */
    if ((parseInt(ipArr[0]) >= 224) && (parseInt(ipArr[0]) <= 239))
    {
      message = I18N.get(title) + I18N.get(" can't be 224.0.0.0 ~ 239.255.255.255");
      return message;
    }
  }

  if (classEValid == false)
  {
    /* check if in class E (240~255) */
    if ((parseInt(ipArr[0]) >= 240) && (parseInt(ipArr[0]) <= 255))
    {
      message = I18N.get(title) + I18N.get(" can't be 240.0.0.0 ~ 255.255.255.255");
      return message;
    }
  }

  return message;
}

/***********************************
check input ip validation.
note  :
***********************************/
function isIpv4Address(addrString)
{
    var ipArr = addrString.split (".");

    if ( (addrString == '') || (ipArr.length != 4) )
    {
        return false;
    }

    for (var i = 0; i < 4; i++)
    {
        /* check length */
        if ((ipArr[i].length == 0) || (ipArr[i].length > 3))
        {
            return false;
        }

        /* check is number */
        if (isNaN(ipArr[i]) == true)
        {
            return false;
        }

        /* check range in 0~255 */
        if ((0 > ipArr[i]) || (ipArr[i] > 255))
        {
            return false;
        }
    }
    return true;
}

function isxdigit(value)
{
    if(value == null)
    {
        return false;
    }

    if(value.match(/[^0-9|^a-f]/gi))
    {
        return false;
    }
    return true;
}

/***********************************
check input ip validation.
note  :
    do length check
    do format check
    do value check
***********************************/
function isIpv6Address(addrString)
{
    var v6MaxLen = 56;
    var scopeIdIndex;
    var inputAddr, buf;
    var arIndex = 0;
    var foundDoubleColon = 0; /* 0: not_found; 1: has_found */
    var colonCount = 0;

    inputAddr = addrString.split('');

    if(addrString.length > v6MaxLen)
    {
        return false;
    }

    /* check address with scope ID */
    scopeIdIndex = addrString.indexOf("%");

    if(scopeIdIndex > 0)
    {
        scopeIdIndex = scopeIdIndex+1;

        if(true == isNaN(addrString.substring(scopeIdIndex)))
        {
            return false;
        }

        inputAddr = addrString.slice(0, scopeIdIndex-1).split('');
    }

    for(;;)
    {
        var numCount = 0;
        var preArIndex = arIndex;

        while(isxdigit(inputAddr[arIndex]) == true)
        {
            numCount++;
            arIndex++;
        }

        if(numCount > 4)
        {
            /*alert("HEX between colon should not more than 4.");*/
            return false;
        }

        if(inputAddr[arIndex] == null)
        {
            break;
        }

        if(inputAddr[arIndex]!= ':')
        {
            /* if is not v6, should be v4 addrsss. */
            if(inputAddr[arIndex] == '.')
            {
                var v4Addr;

                /* find next ':' */
                for(i=1; i<=12; i++)
                {
                    if(inputAddr[arIndex+i] == null)
                    {
                        break;
                    }
                    if(inputAddr[arIndex+i] == ':')
                    {
                        break;
                    }
                }

                /*v4Addr = inputAddr.slice(preArIndex, arIndex+i);*/
                v4Addr = addrString.substring(preArIndex, addrString.length);

                if(isIpv4Address(v4Addr)==true)
                {
                    break;
                }
            }
            return false;
        }

        colonCount++;  /* here, inputAddr[arIndex] is ':' */

        if( (numCount == 0) && (arIndex == 0) )  /* address begin with colon */
        {
            arIndex++;

            if( (inputAddr[arIndex]!= ':') || (inputAddr[arIndex]== null))
            {
                return false;
            }
            colonCount++;
            foundDoubleColon = 1;  /* has found */
        }
        else
        {
            arIndex++;

            if(inputAddr[arIndex]== ':')
            {
                colonCount++;

                if(foundDoubleColon == 1)
                {
                    return false;
                }
                foundDoubleColon = 1;
                arIndex ++;
            }
        }
    }

    if( (colonCount==0) || (colonCount > 7) )
    {
        return false;
    }

    return true;
}

function checkIpv6 (title, objId)
{
  var message = '';
  var ipStr = mainIframe.document.getElementById(objId).value;

  if(ipStr == "")
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  if(false == isIpv6Address(ipStr))
  {
    message = I18N.get(title) + I18N.get("'s value is invalid.");
    return message;
  }

  return message;
}

/* This API check IPv4 and IPv6
 */
function checkIpBoth (title, objId)
{
  var message = '';
  var ipStr = mainIframe.document.getElementById(objId).value;

  if(ipStr == "")
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  if(isIpv4Address(ipStr))
  {
    message = checkIp(title, objId);
  }
  else
  {
    message = checkIpv6(title, objId);
  }

  return message;
}

function checkIpv6Prefix (title, objId)
{
  var message = '';
  var ipStr = mainIframe.document.getElementById(objId).value;
  var ipArr = ipStr.split ("/");

  if(ipStr == "")
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  /* input with prefix
   */
  if(ipArr[1] != null)
  {
    if((0 > ipArr[1]) || (ipArr[1] > 128))
    {
      message = I18N.get(title) + I18N.get("contains invalid prefix length.");
      return message;
    }
  }

  if(false == isIpv6Address(ipArr[0]))
  {
    message = I18N.get(title) + I18N.get("'s value is invalid.");
    return message;
  }

  return message;
}

/* This API check input field that accept both network mask and prefix length.
 */
function checkMaskPrefix (title, objId)
{
  var message = '';
  var ipStr = mainIframe.document.getElementById(objId).value;

  if(ipStr == "")
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  if(isIpv4Address(ipStr))
  {
    message = checkIp(title, objId);
  }
  else
  {
    message = checkNum(title, ipStr, 1, 128);
  }

  return message;
}

/* check ip */
function checkIp (title, objId)
{
  var message = '';
  var ipStr = mainIframe.document.getElementById(objId).value;
  var ipArr = ipStr.split (".");

  if (ipStr == '')
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  if (ipArr.length != 4)
  {
    message = I18N.get(title) + I18N.get(" is invalid format.");
    return message;
  }

  for (var i = 0; i < 4; i++)
  {
    /* check length */
    if ((ipArr[i].length == 0) || (ipArr[i].length > 3))
    {
      message = I18N.get(title) + I18N.get(" is invalid format.");
      return message;
    }

    /* check is number */
    if (isNaN(ipArr[i]) == true)
    {
      message = I18N.get(title) + I18N.get("'s value is invalid.");
      return message;
    }

    /* check range in 0~255 */
    if ((0 > ipArr[i]) || (ipArr[i] > 255))
    {
      message = I18N.get(title) + I18N.get("'s value is invalid.");
      return message;
    }
  }

  switch(objId)
  {
    case "subnetMask":
    case "routingStaticMask":
     /* check subnet mask */
     if (checkSubnetMask(ipArr) != true)
     {
       message = I18N.get(title) + I18N.get("'s value is invalid.");
     }
     break;

    case "filterStartIp":
    case "filterEndIp":
     /* check ip range : title ,ipArr , zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     message = checkIpRange(title, ipArr, false, true, true, true, true, true);
     break;

    case "remoteLogHostIp1":
    case "remoteLogHostIp2":
    case "remoteLogHostIp3":
    case "remoteLogHostIp4":
    case "remoteLogHostIp5":
    case "smtpIp":
    case "sntpIp":
    case "ntpHostIp":
    case "sflowRcvrIpAddr":
    case "tftpIp":
    case "ipSourceGuardBindingIp":
    case "routingStaticHop":
     /* check ip range : title ,ipArr , zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     message = checkIpRange(title, ipArr, false, false, false, false, false, false);
     break;

    case "sysIp":
    case "getewayIp":
    case "routingStaticIpTxt":
     /* check ip class : title ,ipArr , classAValid, classBValid, classCValid, classDValid, classEValid */
     if ((message = checkIpClass(title, ipArr, true, true, true, false, false)) != '')
     {
       return message;
     }

     /* check ip range : title ,ipArr , zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     if ((message = checkIpRange(title, ipArr, true, false, false, false, false, false)) != '')
     {
       return message;
     }
     break;

    case "snmpv3RemoteIp":
     /* check ip range : title, ipArr, zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     message = checkIpRange(title, ipArr, false, true, true, true, true, false);
     break;

    case "dhcpStartIP":
    case "dhcpEndIP":
     /* check ip range : title, ipArr, zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     message = checkIpRange(title, ipArr, false, true, true, true, true, false);
     break;

    case "dhcpPoolIpAddr":
     /* check ip range : title, ipArr, zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     message = checkIpRange(title, ipArr, false, true, false, false, false, false);
     break;

    case "multicastIP":
    case "startMulticastIp":
    case "endMulticastIp":
     /* check ip range : title ,ipArr , zeroIpValid, zeroNetworkValid, loopBackValid, multicastValid, testingValid, broadcastValid */
     if ((message = checkIpClass(title, ipArr, false, false, false, true, false, false)) != '')
     {
       return message;
     }

     /* check ip class : title ,ipArr , classAValid, classBValid, classCValid, classDValid, classEValid */
     if ((message = checkIpRange(title, ipArr, false, false, false, true, false)) != '')
     {
       return message;
     }
     break;
  }

  return message;
}

/* check mac */
function checkMac (title, objId)
{
  var message = '';
  var isValid = false;
  var macRE1 = /^[0-9a-f]{12}$/i;
  var macStr = mainIframe.document.getElementById(objId).value;
  var macArr = macStr.split ("-");

  if (macStr == '')
  {
    message = I18N.get("Please input ") + I18N.get(title) + I18N.get(".");
    return message;
  }

  /* check value */
  if (macArr.length == 1) /* xxxxxxxxxxxx */
  {
    if (macRE1.test(macStr) == false)
    {
      message = I18N.get(title) + I18N.get("'s value is invalid.");
    }
  }
  else if (macArr.length == 6) /* x-x-x-x-x-x */
  {
    for (var i = 0; i < 6; i++)
    {
      var val = parseInt('0x'+macArr[i]);
      var valMax = parseInt('0xFF');

      if ((macArr[i].length == 0) || (macArr[i].match(/[^0-9|^a-f]/gi)) || (val > valMax))
      {
        message = I18N.get(title) + I18N.get("'s value is invalid.");
      }
    }
  }
  else
  {
    message = I18N.get(title) + I18N.get(" is invalid format.");
  }

  return message;
}

/***********************************
check input string.
note  :
         args[0] title (str) : the obj title
         args[1] objId (str) : the obj id
         args[2] min (int) : min string length
         args[3] max (int) : max string length
         args[4] spaceVaild (true/false) : space is vaild or not
         args[5] (str) : another individual invalid character
         ... and so on
***********************************/
function checkStr (title, str, min, max, spaceVaild)
{
  var com_except_char = new Array();
  var args = checkStr.arguments;
  var message = '';

  for (var i = 0; i < str.length; i++)
  {
    var c = str.charCodeAt(i);

    /* check is printble char */
    if ((c < 32) || (c > 126))
    {
      message = I18N.get(title) + I18N.get(" contain invalid character.");
      return message;
    }

    /* check space */
    if ((c == 32) && (spaceVaild == false))
    {
      message = I18N.get(title) + I18N.get(" cannot contain spaces.");
      return message;
    }

    /* check common except char */
    com_except_char[0] = '?';  /* sys_adpt.h define except char */

    for (var j = 0; com_except_char[j] != null; j++)
    {
      if (c == com_except_char[j].charCodeAt(j))
      {
        message = I18N.get(title) + I18N.get(" cannot contain character ") + com_except_char[j] + I18N.get(".");
        return message;
      }
    }

    /* check individual except char */
    for (var k = 5; args[k] != null; k++)
    {
      except_char = args[k];

      if (c == except_char.charCodeAt(k))
      {
        message = I18N.get(title) + I18N.get(" cannot contain character ") + except_char + I18N.get(".");
        return message;
      }
    }
  }

  /* check string len */
  if ((str.length > max) || (str.length < min))
  {
    message = I18N.get(title) + I18N.get(" length is ") + min + "-" + max + I18N.get(".");
    return message;
  }

  return message;
}

/* check input email */
function checkMail (title, str, min, max, spaceVaild)
{
  var message = '';
  var isFound = false;

  message = checkStr(title, str, min, max, spaceVaild);

  if ((message == '') && (str.length != 0))
  {
    /* check have @ */
    for (var i = 0; i < str.length; i++)
    {
      var c = str.charCodeAt(i);

      if (c == 64)
      {
        isFound = true;
      }
    }

    if (isFound == false)
    {
      message = I18N.get(title) + I18N.get(" is invalid format.");
    }
  }

  return message;
}

/* check need sent form */
function checkNeedSent (formObj)
{
  if (formObj.needSent == false)
  {
    alert(I18N.get('Configuration not be changed.'));
    return false;
  }

  return true;
}

/* check table and set sent value */
function checkTable (formObj, tableObj)
{
  var changeNum = 0;

  /* tr loop */
  for (var k = 0; tableObj.rowArr[k] != null; k++)
  {
    /* td loop */
    for (var l = 0; tableObj.rowArr[k][l] != null; l++)
    {
      /* td obj loop */
      for (var m = 1; tableObj.rowArr[k][l][m] != null; m++)
      {
        var obj = mainIframe.document.getElementById(tableObj.rowArr[k][l][m][2]);

        if ((obj != null) && (obj.disabled == false))
        {
          var message = '';
          var mustSet = false;
          var isChange = false;

          /* switch type */
          switch (tableObj.rowArr[k][l][m][0])
          {
            case 'inputNum' :
                  /* input number : define type, title, obj id, must set, null vaild, size, min, max, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj value, min, max */
                    message = checkNum(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'inputFloatNum' :
                  /* input float number : define type, title, obj id, must set, null vaild, size, min, max, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj value, min, max */
                    message = checkFloatNum(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'inputHex' :
                  /* input hexadecimal value : define type, title, obj id, must set, null vaild, size, min, max, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj value, min, max */
                    message = checkHex(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7]);
                  }

                  if (parseInt('0x'+obj.value) != parseInt('0x'+tableObj.rowArr[k][l][m][8]))
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputIp' :
                  /* input ip : define type, title, obj id, must set, null vaild, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj id */
                    message = checkIp(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputIpv6' :
                  /* input ipv6 : define type, title, obj id, must set, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj id */
                    message = checkIpv6(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputIpv6pre' :
                  /* input ipv6 with prefix : define type, title, obj id, must set, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj id */
                    message = checkIpv6Prefix(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputIpBoth' :
                  /* input ipv4/v6 : define type, title, obj id, must set, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj id */
                    message = checkIpBoth(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputMaskPrefix' :
                  /* input net mask / prefix length : define type, title, obj id, must set, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                    /* title, obj id */
                    message = checkMaskPrefix(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;

            case 'inputMac' :
                  /* input mac : define type, title, obj id, must set, null vaild, size, value */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  /* if can't be null or have input value, check input value */
                  if ((tableObj.rowArr[k][l][m][4] == false) || (obj.value != ''))
                  {
                     /* title, obj id */
                     message = checkMac(tableObj.rowArr[k][l][m][1], tableObj.rowArr[k][l][m][2]);
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][6])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'inputText' :
            case 'singlePassword' :
                  /* input text : define type, title, obj id, must set, space vaild, size, min, max, value */
                  /* title, obj value, min, max, space vaild */
                  message = checkStr(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][4]);
                  mustSet = tableObj.rowArr[k][l][m][3];

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'inputMail' :
                  /* input email : define type, title, obj id, must set, space vaild, size, min, max, value */
                  /* title, obj value, min, max, space vaild */
                  message = checkMail(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][4]);
                  mustSet = tableObj.rowArr[k][l][m][3];

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'password' :
                  /* password : define type, title, obj id, must set, space vaild, size, min, max, value */
                  /* title, obj value, min, max, space vaild */
                  mustSet = tableObj.rowArr[k][l][m][3];
                  message = checkStr(tableObj.rowArr[k][l][m][1], obj.value, tableObj.rowArr[k][l][m][6], tableObj.rowArr[k][l][m][7], tableObj.rowArr[k][l][m][4]);
                  var pswdObj = mainIframe.document.getElementById('pswd');
                  var pswdConfirmObj = mainIframe.document.getElementById('pswdConfirm');

                  if (pswdObj.value != pswdConfirmObj.value)
                  {
                    alert(I18N.get("Password inconsistent, please try again."));
                    pswdObj.value = "";
                    pswdConfirmObj.value = "";
                    pswdObj.focus();
                    return false;
                  }

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'select' :
                  /* select : define type, title, obj id, must set, is multiple, size, text option list, value option list, selected value, funtion name*/
                  mustSet = tableObj.rowArr[k][l][m][3];

                  if (obj.value != tableObj.rowArr[k][l][m][8])
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
            case 'checkBox' :
                  /* checkBox : define type, title, obj id, must set, description string, status, funtion name */
                  mustSet = tableObj.rowArr[k][l][m][3];

                  if (obj.checked == true)
                  {
                    obj.value = 1;
                  }
                  else
                  {
                    obj.value = 0;
                  }

                  if ((tableObj.rowArr[k][l][m][5] == 1) || (tableObj.rowArr[k][l][m][5] == 'Enabled'))
                  {
                    var oriVal = 1;
                  }
                  else
                  {
                    var oriVal = 0;
                  }

                  if (obj.value != oriVal)
                  {
                    isChange = true;
                    changeNum ++;
                  }
                  break;
          }

          /* check fail */
          if (message != '')
          {
            alert(message);
            obj.focus();
            return false;
          }

          if ((isChange == true) || (mustSet == true))
          {
            /* save obj id and value to send*/
            formObj.sendArr[formObj.sendNum++] = [tableObj.rowArr[k][l][m][2], obj.value];
          }
        }
      }
    }
  }

  /* check need sent */
  if (changeNum != 0)
  {
    formObj.needSent = true;
  }

  return true;
}

/* check list and set sent value */
function checkList (formObj, listObj)
{
  var changeNum = 0;
  var dataIndex = 0;

  if (listObj.dataMax == 'none')
  {
    listObj.dataMax = listObj.dataNum;
  }

  /* index loop */
  for (var i = 1; i <= listObj.indexNum; i++)
  {
    /* index data max loop */
    for (var j = 0; j < listObj.indexDataMax; j++)
    {
       /* dataIndex loop */
      for (; dataIndex <= listObj.dataMax; dataIndex++)
      {
        if (listObj.dataArr[dataIndex])
        {
          /* dataArr tr loop */
          for (var k = 0; listObj.dataArr[dataIndex][k] != null; k++)
          {
            /* td loop */
            for (var l = 0; listObj.dataArr[dataIndex][k][l] != null; l++)
            {
              /* td obj loop */
              for (var m = 1; listObj.dataArr[dataIndex][k][l][m] != null; m++)
              {
                var obj = mainIframe.document.getElementById(listObj.dataArr[dataIndex][k][l][m][2]);

                if ((obj != null) && (obj.disabled == false))
                {
                  var message = '';
                  var mustSet = false;
                  var isChange = false;

                  /* switch type */
                  switch (listObj.dataArr[dataIndex][k][l][m][0])
                  {
                    case 'inputNum' :
                          /* input number : define type, title, obj id, must set, null vaild, size, min, max, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj value, min, max */
                            message = checkNum(listObj.dataArr[dataIndex][k][l][m][1], obj.value, listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][8])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;
                    case 'inputFloatNum' :
                          /* input float number : define type, title, obj id, must set, null vaild, size, min, max, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];
                          
                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj value, min, max */
                            message = checkFloatNum(listObj.dataArr[dataIndex][k][l][m][1], obj.value, listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7]);
                          }
                          
                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][8])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;
                    case 'inputHex' :
                          /* input number : define type, title, obj id, must set, null vaild, size, min, max, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj value, min, max */
                            message = checkHex(listObj.dataArr[dataIndex][k][l][m][1], obj.value, listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7]);
                          }

                          if (parseInt('0x'+obj.value) != parseInt('0x'+listObj.dataArr[dataIndex][k][l][m][8]))
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputIp' :
                          /* input ip : define type, title, obj id, must set, size, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj id */
                            message = checkIp(listObj.dataArr[dataIndex][k][l][m][1], listObj.dataArr[dataIndex][k][l][m][2]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][6])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputIpv6' :
                          /* input ipv6 : define type, title, obj id, must set, size, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj id */
                            message = checkIpv6(listObj.dataArr[dataIndex][k][l][m][1], listObj.dataArr[dataIndex][k][l][m][2]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][6])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputIpv6pre' :
                          /* input ipv6 with prefix : define type, title, obj id, must set, size, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj id */
                            message = checkIpv6Prefix(listObj.dataArr[dataIndex][k][l][m][1], listObj.dataArr[dataIndex][k][l][m][2]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][6])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputIpBoth' :
                          /* input ipv4/v6 : define type, title, obj id, must set, size, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj id */
                            message = checkIpBoth(listObj.dataArr[dataIndex][k][l][m][1], listObj.dataArr[dataIndex][k][l][m][2]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][6])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputMaskPrefix' :
                          /* input net mask / prefix length : define type, title, obj id, must set, size, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          /* if can't be null or have input value, check input value */
                          if ((listObj.dataArr[dataIndex][k][l][m][4] == false) || (obj.value != ''))
                          {
                            /* title, obj id */
                            message = checkMaskPrefix(listObj.dataArr[dataIndex][k][l][m][1], listObj.dataArr[dataIndex][k][l][m][2]);
                          }

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][6])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;

                    case 'inputText' :
                    case 'singlePassword' :
                          /* input text : define type, title, obj id, must set, space vaild, size, min, max, value */
                          /* title, obj value, min, max, space vaild */
                          message = checkStr(listObj.dataArr[dataIndex][k][l][m][1], obj.value, listObj.dataArr[dataIndex][k][l][m][6], listObj.dataArr[dataIndex][k][l][m][7], listObj.dataArr[dataIndex][k][l][m][4]);
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][8])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;
                    case 'password' :
                          /* password : define type, title, obj id, must set, space vaild, size, min, max, value */
                          /* obj id, size, max, value */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];
                          pswdObj = mainIframe.document.getElementById('pswd');
                          pswdConfirmObj = mainIframe.document.getElementById('pswdConfirm');

                          if (pswdObj.value != pswdConfirmObj.value)
                          {
                            alert(I18N.get("Password inconsistent, please try again."));
                            pswdObj.value = "";
                            pswdConfirmObj.value = "";
                            pswdObj.focus();
                            return false;
                          }
                          break;
                    case 'select' :
                          /* select : define type, title, obj id, must set, is multiple, size, text option list, value option list, selected value, funtion name*/
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          if (obj.value != listObj.dataArr[dataIndex][k][l][m][8])
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;
                    case 'checkBox' :
                          /* checkBox : define type, title, obj id, must set, description string, status, funtion name */
                          mustSet = listObj.dataArr[dataIndex][k][l][m][3];

                          if (obj.checked == true)
                          {
                            obj.value = 1;
                          }
                          else
                          {
                            obj.value = 0;
                          }

                          if ((listObj.dataArr[dataIndex][k][l][m][5] == 1) || (listObj.dataArr[dataIndex][k][l][m][5] == 'Enabled'))
                          {
                            var oriVal = 1;
                          }
                          else
                          {
                            var oriVal = 0;
                          }

                          if (obj.value != oriVal)
                          {
                            isChange = true;
                            changeNum ++;
                          }
                          break;
                  }

                  /* check fail */
                  if (message != '')
                  {
                    alert(message);
                    obj.focus();
                    return false;
                  }

                  if ((isChange == true) || (mustSet == true))
                  {
                    /* save obj id and value to send*/
                    formObj.sendArr[formObj.sendNum++] = [listObj.dataArr[dataIndex][k][l][m][2], obj.value];
                  }
                }
              }
            }
          }
        }
      }
    }
  }

  /* check need sent */
  if (changeNum != 0)
  {
    formObj.needSent = true;
  }

  return true;
}

/* check and set obj change */
function checkObjChange (formObj, defineType, objId, mustSet, orValue)
{
  var obj = mainIframe.document.getElementById(objId);

  if ((obj != null) && (obj.disabled == false))
  {
    var isChange = false;

    /* switch type */
    switch (defineType)
    {
      case 'inputNum' :
      case 'inputFloatNum' :
      case 'inputText' :
      case 'inputIp' :
      case 'inputIpv6' :
      case 'inputIpv6pre' :
      case 'inputIpBoth' :
      case 'inputMac' :
      case 'select' :
      case 'singlePassword' :
            if (obj.value != orValue)
            {
              isChange = true;
            }
            break;
      case 'password' :
            pswdObj = mainIframe.document.getElementById('pswd');
            pswdConfirmObj = mainIframe.document.getElementById('pswdConfirm');

            if (pswdObj.value != pswdConfirmObj.value)
            {
              alert(I18N.get("Password inconsistent, please try again."));
              pswdObj.value = "";
              pswdConfirmObj.value = "";
              pswdObj.focus();
              return false;
            }

            if (obj.value != orValue)
            {
              isChange = true;
            }
            break;
      case 'checkBox' :
            if (obj.checked == true)
            {
              obj.value = 1;
            }
            else
            {
              obj.value = 0;
            }

            if ((orValue == 1) || (orValue == 'Enabled'))
            {
              var oriVal = 1;
            }
            else
            {
              var oriVal = 0;
            }

            if (obj.value != oriVal)
            {
              isChange = true;
            }
            break;
    }

    if (isChange == true)
    {
      /* save obj id and value to send */
      formObj.sendArr[formObj.sendNum++] = [objId, obj.value];
      formObj.needSent = true;
    }
    else if ((isChange == false) && (mustSet == true))
    {
      /* save obj id and value to send when formObj.needSent be true */
      formObj.sendArr[formObj.sendNum++] = [objId, obj.value];
    }
  }
}
